'use strict';

function BCPRemoveInvestmentModalCtrl($scope, BanksList){
    var elementId = "#modal-investment-remove";

    $scope.option = {};
    $scope.cbso = {};
    $scope.BankService = {};

    $scope.$on('Bank:openRemoveInvestmentModal', function(event, params){
        $scope.option = params.option;
        $scope.BankService = params.BankService;
        $scope.cbso = params.cbso;

        if($scope.BankService.symbol == 'REVOLVING_LOAN')
        {
            $scope.title = 'Likwidacja kredytu obrotowego';
            $scope.msg = 'Zlikwidowanie kredytu obrotowego spowoduje obniżenie rachunku bieżącego!';
        }
        else
        {
            $scope.title = 'Likwidacja lokaty';
            $scope.msg = 'Zlikwidowanie lokaty przed ustaloną datą skutkuje utratą odsetek!';
        }


        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }


    $scope.remove = function(){
        var value = $scope.cbso.value;
        if($scope.option.removeCompanyBankService($scope.cbso))
        {
            if($scope.BankService.symbol == 'REVOLVING_LOAN')
            {
                BanksList.getCurrentAccount().company_bank_service_options[0].value -= (value);
                if($scope.cbso.id == 0)
                {
                    BanksList.getCurrentAccount().company_bank_service_options[0].value += $scope.option.cost;
                }
            }
            else
            {
                BanksList.getCurrentAccount().company_bank_service_options[0].value += (value);
            }
        }
        $scope.closeModal();
    }
}

BCPRemoveInvestmentModalCtrl.$inject = ['$scope', 'BanksList'];